<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:akcuakz="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v1_0/AKC_UAKZ.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v1_0/AKC_UAKZ.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Trader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Trader.xsd" xmlns:tr8="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="UTF-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:value-of select="name()"/> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_AKC_UAKZ" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_AKC_UAKZ"> <xsl:for-each select=" ns1:Header |  ns4:* | akcuakz:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. KWOTY PODATKU --> <!-- <xsl:apply-templates mode="KwotaPodatku" select="."/>--> <!-- SZABLON DOT. WYROBOW --> <xsl:apply-templates mode="Wyroby" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <!--<xsl:apply-templates mode="Adnotacje" select="."/>--> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator podatkowy NIP płatnika</b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>Numer własny:</b> <span class="cz18"> <xsl:value-of select="@selfRef"/> </span> <br/> <b>Data wypełnienia deklaracji:</b> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="center" valign="bottom"> <xsl:if test="@refNumber"> Nr referencyjny nadany przez System eZefir:<br/> <xsl:value-of select="@refNumber"/> </xsl:if> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">AKC-UAKZ</span> </td> </tr> <tr> <!--<td height="61" width="154"/> --> <td > <div align="center"> <span class="nag1">DEKLARACJA KWARTALNA UPROSZCZONA<br/> W SPRAWIE PODATKU AKCYZOWEGO OD NABYCIA WEWNĄTRZWSPÓLNOTOWEGO WYROBÓW AKCYZOWYCH OBJĘTYCH ZEROWĄ STAWKĄ PODATKU AKCYZOWEGO <br/>za</span> <br/> <!--	<span class="nag1"/>--> </div> </td> <!--	<td width="243"/> --> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" width="955"> <xsl:if test="@periodType and normalize-space(@periodType)='Miesiac'"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <br/> <div align="center" class="cz18"/> </td> </tr> </xsl:if> <xsl:if test="@periodType and normalize-space(@periodType)='Kwartal'"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Kwartał</b> <br/> <xsl:choose> <xsl:when test="substring(@period,6,7)='01'"> <div align="center" class="cz18">I</div> </xsl:when> <xsl:when test="substring(@period,6,7)='04'"> <div align="center" class="cz18">II</div> </xsl:when> <xsl:when test="substring(@period,6,7)='07'"> <div align="center" class="cz18">III</div> </xsl:when> <xsl:when test="substring(@period,6,7)='10'"> <div align="center" class="cz18">IV</div> </xsl:when> <xsl:otherwise> <xsl:text> ... </xsl:text> </xsl:otherwise> </xsl:choose> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <!--<td align="left" valign="top" width="206"> <br/> <div align="center" class="cz18"/> </td> --> </tr> </xsl:if> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 78 ust. 1 pkt 3b ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.), zwanej dalej „ustawą”.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top">Do 10. dnia przypadającego w drugim miesiącu po kwartale, w którym powstał obowiązek podatkowy, w przypadku dokonanego na potrzeby wykonywanej przez podatnika działalności gospodarczej nabycia wewnątrzwspólnotowego wyrobów akcyzowych wymienionych w załączniku nr 2 do ustawy, znajdujących się poza procedurą zawieszenia poboru akcyzy i opodatkowanych na terytorium kraju zerową stawką podatku akcyzowego.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top">Urząd skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu podatkiem akcyzowym; jeżeli czynności podlegające opodatkowaniu są wykonywane lub stany faktyczne podlegające opodatkowaniu występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – zgodnie z art. 14 ust. 4–4f ustawy; jeżeli właściwym organem podatkowym jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie, to miejscem składania jest Trzeci Urząd Skarbowy Warszawa-Śródmieście w Warszawie.</td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="2"> <b>6. Naczelnik urzędu skarbowego</b> <br/> <span class="cz18"> <xsl:value-of select="@taxOffice"/> </span> </td> </tr> <tr> <td class="style3" colspan="2"> <b>7. Cel złożenia formularza</b>(zaznaczyć własciwy kwadrat):  </td> </tr> <tr> <td align="left" valign="top" width="422">1. złożenie deklaracji<br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td align="left" valign="top" width="471">2. korekta deklaracji<sup>1)</sup> <br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/> <xsl:value-of select="@justification"/> </xsl:if> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE PODATNIKA</span> </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE PODATNIKA </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>8. Rodzaj podatnika </b>(zaznaczyć właściwy kwadrat): </td> </tr> <tr> <td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='N'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='F'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>9. Nazwa pełna</b> <sup>3)</sup> <b>/ Nazwisko, pierwsze imię</b> <sup>4)</sup> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> <span class="cz18"> <xsl:value-of select=".//tr8:PrivatePerson/tr8:BasicData/@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//tr8:PrivatePerson/tr8:BasicData/@surname"/> </span> <!--<span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> --> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY<sup>2)</sup>/ ADRES ZAMIESZKANIA<sup>3)</sup> </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>10. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>11. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>12. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>13. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>14. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>15. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>16. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan = "3"> <b>17. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <!--<td width="130"> <b>17. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> --> <!--<td width="181"> <b>18. Poczta</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> </td> --> <td colspan="2"> <b>18. Kod pocztowy</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> <br/> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">AKC-UAKZ</span> <sub style="cz9">(1)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. KWOTY PODATKU --> <!--	<xsl:template match="ns1:Header | akcuakz:*" mode="KwotaPodatku"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="4"> <b>C. WYSOKOŚĆ PODATKU AKCYZOWEGO </b> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="40"> <p/> <p/> <p/> <p/> </td> <td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"> <b>Podatek akcyzowy do zapłaty </b> <br/> <br/> <br/> <br/> <br/> Kwota z poz. 85 </td> <td align="left" colspan="2" valign="top" width="283"> <b>18.</b> <br/> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@toPay),'# ##0')"/> </div> <br/> <div align="right" class="cz19" valign="top">zł</div> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">AKC-KZ</span> <sub style="cz9">(1)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:template> --> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | akcuakz:*" mode="Wyroby"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"/> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="7">C. WYROBY	AKCYZOWE	WYMIENIONE	W	ZAŁĄCZNIKU	NR	2	DO	USTAWY OPODATKOWANE ZEROWĄ STAWKĄ PODATKU AKCYZOWEGO</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td>Lp.</td> <td width="160">Nazwa wyrobów akcyzowych</td> <td width="120">Ośmiocyfrowy kod CN</td> <td width="120">Ilość wyrobów<sup>4)</sup> </td> <td width="130">Stawka podatku, jaka miałaby zastosowanie w przypadku niespełnienia warunków uprawniających do zastosowania zerowej stawki podatku akcyzowego </td> <td width="79">Podatek akcyzowy, który przypadałby do zapłaty w przypadku niespełnienia warunków uprawniających do zastosowania zerowej stawki podatku akcyzowego<sup>5)</sup> </td> <!--	<td width="140">Rodzaj preferencji (zaznaczyć odpowiedni kwadrat)  </td> --> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> <td> <div align="center">e</div> </td> <td> <div align="center">f</div> </td> <!--			<td> <div align="center">g</div> </td> --> </tr> <xsl:for-each select="//ns1:Item | //akcuakz:Item"> <tr> <td> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@id"/> </div> </td> <td> <div align="left" class="cz14" valign="top"> <xsl:value-of select="@exciseGoodsName"/> </div> </td> <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@numberOfGoods"/> </div> </td> <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@taxRate"/> </div> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@taxRatePercentage"/> </div> </td> <td> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> </div> </td> <!--		<td> <div align="right" class="cz14" valign="top"> <xsl:if test="@typeOfPreferences and normalize-space(@typeOfPreferences)='stawkazero'"> stawka 0 </xsl:if> <xsl:if test="@typeOfPreferences and normalize-space(@typeOfPreferences)='zwolnienie'"> zwolnienie </xsl:if> </div> </td> --> </tr> </xsl:for-each> <tr align="left" valign="top"> <td height="48"/> <td bgcolor="#CCCCCC" colspan="4"> <b>Razem: </b> </td> <td> <b>199.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(.//@sum),'# ##0')"/> </div> </td> <!--	<td bgcolor="#CCCCCC"> </td> --> </tr> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | akcuakz:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">D. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span> </b> <br/> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td height="37" width="402"> <b>200. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>201. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname"/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>202. Data wypełnienia deklaracji</b>(dzień-miesiąc-rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> <td> <b>203. Podpis podatnika lub osoby reprezentującej podatnika  </b> </td> </tr> <tr align="left" valign="top"> <td colspan="2" height="70"> <b>204. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika</b>(pole nieobowiązkowe) <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:* | akcuakz:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3" height="36"> <span class="nag1">F. ADNOTACJE URZĘDU SKARBOWEGO </span> <br/> <span class="cz10">W przypadku deklaracji złożonej w wersji elektronicznej wypełnienie pól: 93, 94 i 95 nie jest obowiązkowe.</span> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>93. Uwagi urzędu skarbowego <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>94. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>95. Podpis przyjmującego formularz </b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | akcuakz:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia</b> </p> <sup>1)</sup> Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2020 r. poz. 1325, z późn. zm.).<br/> <sup>2)</sup> Dotyczy podatników niebędących osobami fizycznymi.<br/> <sup>3)</sup> Dotyczy podatników będących osobami fizycznymi.<br/> <sup>4)</sup> Ilości wyrażone w gigadżulach, tysiącach kilogramów, tysiącach litrów zaokrągla się z dokładnością do trzech miejsc po przecinku.<br/> <sup>5)</sup> Kwoty  podatków  zaokrągla  się  do  pełnych  złotych  w  ten  sposób,  że  końcówki  kwot  wynoszące  mniej  niż  50  groszy  pomija  się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa.<br/> <p align="center"> <b>Pouczenia</b> </p> Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">AKC-UAKZ</span> <sub style="cz9">(1)</sub> <b>/3</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>